@extends('karyawan.layout.master')

@section('title', 'Pengaturan Akun')

@push('styles')
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', 'Roboto', sans-serif;
        }

        body {
            margin: 0;
            padding: 0;
            background: #ffffff;
            overflow: hidden;
        }

        .fullscreen-wrapper {
            /* margin-top: 1000px; */
            margin-bottom: 70px;
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            display: flex;
            flex-direction: column;
            background: #ffffff;
        }

        .settings-header {
            background: linear-gradient(135deg, #354591 0%, #764ba2 100%);
            color: white;
            padding: 30px 20px;
            flex-shrink: 0;
        }

        .settings-header h1 {
            margin: 0;
            font-size: 28px;
            font-weight: 700;
        }

        .settings-header p {
            margin: 8px 0 0 0;
            opacity: 0.9;
            font-size: 14px;
        }

        .settings-content {
            flex: 1;
            margin-top: 70px;
            overflow-y: auto;
            -webkit-overflow-scrolling: touch;
            background: #f8f9fa;
        }

        .profile-section {
            background: white;
            padding: 25px 20px;
            margin: 0;
            border-bottom: 1px solid #f0f0f0;
        }

        .profile-section:last-child {
            border-bottom: none;
        }

        .profile-photo-wrapper {
            display: flex;
            align-items: center;
            gap: 20px;
            margin-bottom: 25px;
            padding-bottom: 25px;
            border-bottom: 2px solid #f0f0f0;
        }

        .profile-photo {
            width: 100px;
            height: 100px;
            border-radius: 50%;
            object-fit: cover;
            border: 4px solid #354591;
            box-shadow: 0 4px 12px rgba(102, 126, 234, 0.3);
            flex-shrink: 0;
        }

        .profile-photo-info {
            flex: 1;
            min-width: 0;
        }

        .profile-photo-info h3 {
            margin: 0 0 5px 0;
            font-size: 20px;
            color: #2d3748;
            overflow: hidden;
            text-overflow: ellipsis;
            white-space: nowrap;
        }

        .profile-photo-info p {
            margin: 0;
            color: #718096;
            font-size: 14px;
            overflow: hidden;
            text-overflow: ellipsis;
            white-space: nowrap;
        }

        .btn-change-photo {
            background: #354591;
            color: white;
            border: none;
            padding: 10px 20px;
            border-radius: 8px;
            font-weight: 600;
            cursor: pointer;
            font-size: 14px;
            transition: all 0.3s;
            flex-shrink: 0;
        }

        .btn-change-photo:hover {
            background: #5568d3;
            transform: translateY(-2px);
            box-shadow: 0 4px 12px rgba(102, 126, 234, 0.4);
        }

        .btn-change-photo:active {
            transform: translateY(0);
        }

        .section-title {
            font-size: 18px;
            font-weight: 700;
            color: #2d3748;
            margin-bottom: 20px;
            display: flex;
            align-items: center;
            gap: 10px;
        }

        .section-title i {
            color: #354591;
        }

        .info-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 15px;
            margin-bottom: 25px;
        }

        .info-item {
            background: #f7fafc;
            padding: 15px;
            border-radius: 8px;
            border-left: 4px solid #354591;
        }

        .info-label {
            font-size: 12px;
            color: #718096;
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            margin-bottom: 5px;
        }

        .info-value {
            font-size: 16px;
            color: #2d3748;
            font-weight: 600;
            overflow: hidden;
            text-overflow: ellipsis;
        }

        .status-badge {
            display: inline-flex;
            align-items: center;
            gap: 6px;
            padding: 6px 12px;
            border-radius: 20px;
            font-size: 13px;
            font-weight: 600;
        }

        .status-badge.aktif {
            background: #d4edda;
            color: #155724;
        }

        .status-badge.nonaktif {
            background: #f8d7da;
            color: #721c24;
        }

        .status-badge.verified {
            background: #d1ecf1;
            color: #0c5460;
        }

        .status-badge.unverified {
            background: #fff3cd;
            color: #856404;
        }

        .form-group {
            margin-bottom: 20px;
        }

        .form-label {
            display: block;
            font-size: 14px;
            font-weight: 600;
            color: #2d3748;
            margin-bottom: 8px;
        }

        .form-control {
            width: 100%;
            padding: 12px 15px;
            border: 2px solid #e2e8f0;
            border-radius: 10px;
            font-size: 15px;
            transition: all 0.3s;
            background: #f7fafc;
        }

        .form-control:focus {
            outline: none;
            border-color: #354591;
            background: white;
            box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
        }

        .form-control:disabled {
            background: #e2e8f0;
            cursor: not-allowed;
        }

        .btn-primary {
            background: #354591;
            color: white;
            border: none;
            padding: 14px 30px;
            border-radius: 10px;
            font-weight: 600;
            font-size: 16px;
            cursor: pointer;
            transition: all 0.3s;
            display: inline-flex;
            align-items: center;
            gap: 8px;
        }

        .btn-primary:hover {
            transform: translateY(-2px);
            box-shadow: 0 8px 20px rgba(102, 126, 234, 0.4);
        }

        .btn-primary:active {
            transform: translateY(0);
        }

        .action-buttons {
            display: flex;
            gap: 15px;
            margin-top: 25px;
            flex-wrap: wrap;
        }

        .alert {
            padding: 15px 20px;
            margin: 0;
            display: flex;
            align-items: center;
            gap: 12px;
            font-size: 14px;
            flex-shrink: 0;
        }

        .alert-success {
            background: #d4edda;
            color: #155724;
            border-left: 4px solid #28a745;
        }

        .alert-danger {
            background: #f8d7da;
            color: #721c24;
            border-left: 4px solid #dc3545;
        }

        .alert-info {
            background: #d1ecf1;
            color: #0c5460;
            border-left: 4px solid #17a2b8;
            margin-bottom: 20px;
        }

        .face-verification-box {
            background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);
            color: white;
            padding: 20px;
            border-radius: 12px;
            text-align: center;
            margin-bottom: 20px;
        }

        .face-verification-box h4 {
            margin: 0 0 10px 0;
            font-size: 18px;
        }

        .face-verification-box p {
            margin: 0 0 15px 0;
            opacity: 0.9;
            font-size: 14px;
        }

        .btn-verify-face {
            background: white;
            color: #f5576c;
            border: none;
            padding: 12px 25px;
            border-radius: 8px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s;
        }

        .btn-verify-face:hover {
            transform: scale(1.05);
            box-shadow: 0 4px 12px rgba(255, 255, 255, 0.3);
        }

        .btn-verify-face:active {
            transform: scale(1);
        }

        .password-strength {
            height: 4px;
            background: #e2e8f0;
            border-radius: 2px;
            margin-top: 8px;
            overflow: hidden;
        }

        .password-strength-bar {
            height: 100%;
            transition: all 0.3s;
            border-radius: 2px;
        }

        .password-strength-weak {
            width: 33%;
            background: #dc3545;
        }

        .password-strength-medium {
            width: 66%;
            background: #ffc107;
        }

        .password-strength-strong {
            width: 100%;
            background: #28a745;
        }

        .input-group {
            position: relative;
        }

        .input-group .toggle-password {
            position: absolute;
            right: 15px;
            top: 50%;
            transform: translateY(-50%);
            background: none;
            border: none;
            color: #718096;
            cursor: pointer;
            padding: 5px;
        }

        .input-group .toggle-password:hover {
            color: #354591;
        }

        /* Responsive Design */
        @media (max-width: 768px) {
            .settings-header {
                padding: 20px 15px;
            }

            .settings-header h1 {
                font-size: 22px;
            }

            .profile-section {
                padding: 20px 15px;
            }

            .profile-photo-wrapper {
                flex-direction: column;
                text-align: center;
                align-items: center;
            }

            .profile-photo-info {
                text-align: center;
            }

            .profile-photo-info h3,
            .profile-photo-info p {
                white-space: normal;
            }

            .action-buttons {
                flex-direction: column;
            }

            .btn-primary {
                width: 100%;
                justify-content: center;
            }

            .info-grid {
                grid-template-columns: 1fr;
            }
        }

        @media (max-width: 480px) {
            .settings-header h1 {
                font-size: 20px;
            }

            .profile-photo {
                width: 80px;
                height: 80px;
            }

            .section-title {
                font-size: 16px;
            }

            .btn-change-photo {
                width: 100%;
                justify-content: center;
            }
        }
    </style>
@endpush

@section('content')
    <div class="fullscreen-wrapper">
        {{-- Alert Messages --}}
        @if (session('success'))
            <div class="alert alert-success">
                <i class="fas fa-check-circle"></i>
                <span>{{ session('success') }}</span>
            </div>
        @endif

        @if (session('error'))
            <div class="alert alert-danger">
                <i class="fas fa-exclamation-circle"></i>
                <span>{{ session('error') }}</span>
            </div>
        @endif

        {{-- Scrollable Content --}}
        <div class="settings-content">
            {{-- Profile Photo Section --}}
            <div class="profile-section">
                <div class="section-title">
                    <i class="fas fa-user-circle"></i>
                    <span>Foto Profil</span>
                </div>

                <div class="profile-photo-wrapper">
                    <img src="{{ $karyawan->foto_profil ? asset('storage/' . $karyawan->foto_profil) : asset('images/default-avatar.png') }}"
                        alt="Profile Photo" class="profile-photo" id="profilePhotoPreview">

                    <div class="profile-photo-info">
                        <h3>{{ auth()->user()->nama }}</h3>
                        <p>{{ $karyawan->nip }}</p>
                        <p style="color: #354591; font-weight: 600;">{{ $karyawan->jabatan->nama ?? '-' }}</p>
                    </div>

                    <form action="{{ route('karyawan.settings.update-photo') }}" method="POST"
                        enctype="multipart/form-data" id="photoForm">
                        @csrf
                        <input type="file" name="foto_profil" id="fotoProfilInput" accept="image/*"
                            style="display: none;">
                        <button type="button" class="btn-change-photo"
                            onclick="document.getElementById('fotoProfilInput').click()">
                            <i class="fas fa-camera"></i> Ubah Foto
                        </button>
                    </form>
                </div>

                {{-- Face Verification Status --}}
                @if (!$karyawan->wajah_terdaftar)
                    <div class="face-verification-box">
                        <h4><i class="fas fa-exclamation-triangle"></i> Wajah Belum Terdaftar</h4>
                        <p>Daftarkan wajah Anda untuk menggunakan fitur absensi dengan face recognition</p>
                        {{-- <button class="btn-verify-face" onclick="alert('Silakan hubungi admin untuk registrasi wajah')">
                            <i class="fas fa-user-check"></i> Daftar Wajah
                        </button> --}}
                        <a href="{{ route('karyawan.wajah.register', $karyawan->id) }}" class="btn btn-sm btn-primary">
                            Daftar Wajah
                        </a>
                    </div>
                @endif
            </div>

            {{-- Personal Information --}}
            <div class="profile-section">
                <div class="section-title">
                    <i class="fas fa-id-card"></i>
                    <span>Informasi Pribadi</span>
                </div>

                <div class="info-grid">
                    <div class="info-item">
                        <div class="info-label">NIP</div>
                        <div class="info-value">{{ $karyawan->nip }}</div>
                    </div>
                    <div class="info-item">
                        <div class="info-label">Email</div>
                        <div class="info-value">{{ auth()->user()->email }}</div>
                    </div>
                    <div class="info-item">
                        <div class="info-label">Departemen</div>
                        <div class="info-value">{{ $karyawan->departemen->nama ?? '-' }}</div>
                    </div>
                    <div class="info-item">
                        <div class="info-label">Jabatan</div>
                        <div class="info-value">{{ $karyawan->jabatan->nama ?? '-' }}</div>
                    </div>
                    <div class="info-item">
                        <div class="info-label">Status Karyawan</div>
                        <div class="info-value">
                            <span class="status-badge {{ $karyawan->status }}">
                                <i
                                    class="fas {{ $karyawan->status == 'aktif' ? 'fa-check-circle' : 'fa-times-circle' }}"></i>
                                {{ ucfirst($karyawan->status) }}
                            </span>
                        </div>
                    </div>
                    <div class="info-item">
                        <div class="info-label">Verifikasi Wajah</div>
                        <div class="info-value">
                            <span class="status-badge {{ $karyawan->wajah_terdaftar ? 'verified' : 'unverified' }}">
                                <i
                                    class="fas {{ $karyawan->wajah_terdaftar ? 'fa-check-circle' : 'fa-exclamation-circle' }}"></i>
                                {{ $karyawan->wajah_terdaftar ? 'Terverifikasi' : 'Belum Verifikasi' }}
                            </span>
                        </div>
                    </div>
                </div>
            </div>

            {{-- Update Email Form --}}
            <div class="profile-section">
                <div class="section-title">
                    <i class="fas fa-envelope"></i>
                    <span>Ubah Email</span>
                </div>

                <form action="{{ route('karyawan.settings.update-email') }}" method="POST">
                    @csrf
                    <div class="form-group">
                        <label class="form-label">Email Saat Ini</label>
                        <input type="email" class="form-control" value="{{ auth()->user()->email }}" disabled>
                    </div>

                    <div class="form-group">
                        <label class="form-label">Email Baru</label>
                        <input type="email" name="email" class="form-control" placeholder="Masukkan email baru"
                            required>
                    </div>

                    <div class="form-group">
                        <label class="form-label">Konfirmasi Password</label>
                        <div class="input-group">
                            <input type="password" name="password" id="confirmPasswordEmail" class="form-control"
                                placeholder="Masukkan password untuk konfirmasi" required>
                            <button type="button" class="toggle-password" onclick="togglePassword('confirmPasswordEmail')">
                                <i class="fas fa-eye"></i>
                            </button>
                        </div>
                    </div>

                    <div class="action-buttons">
                        <button type="submit" class="btn-primary">
                            <i class="fas fa-save"></i> Simpan Email
                        </button>
                    </div>
                </form>
            </div>

            {{-- Update Password Form --}}
            <div class="profile-section">
                <div class="section-title">
                    <i class="fas fa-lock"></i>
                    <span>Ubah Password</span>
                </div>

                <div class="alert alert-info">
                    <i class="fas fa-info-circle"></i>
                    <span>Password harus minimal 8 karakter, mengandung huruf besar, huruf kecil, dan angka</span>
                </div>

                <form action="{{ route('karyawan.settings.update-password') }}" method="POST">
                    @csrf
                    <div class="form-group">
                        <label class="form-label">Password Saat Ini</label>
                        <div class="input-group">
                            <input type="password" name="current_password" id="currentPassword" class="form-control"
                                placeholder="Masukkan password saat ini" required>
                            <button type="button" class="toggle-password" onclick="togglePassword('currentPassword')">
                                <i class="fas fa-eye"></i>
                            </button>
                        </div>
                    </div>

                    <div class="form-group">
                        <label class="form-label">Password Baru</label>
                        <div class="input-group">
                            <input type="password" name="new_password" id="newPassword" class="form-control"
                                placeholder="Masukkan password baru" required oninput="checkPasswordStrength(this.value)">
                            <button type="button" class="toggle-password" onclick="togglePassword('newPassword')">
                                <i class="fas fa-eye"></i>
                            </button>
                        </div>
                        <div class="password-strength">
                            <div class="password-strength-bar" id="passwordStrengthBar"></div>
                        </div>
                        <small id="passwordStrengthText"
                            style="font-size: 12px; color: #718096; margin-top: 5px; display: block;"></small>
                    </div>

                    <div class="form-group">
                        <label class="form-label">Konfirmasi Password Baru</label>
                        <div class="input-group">
                            <input type="password" name="new_password_confirmation" id="confirmPassword"
                                class="form-control" placeholder="Konfirmasi password baru" required>
                            <button type="button" class="toggle-password" onclick="togglePassword('confirmPassword')">
                                <i class="fas fa-eye"></i>
                            </button>
                        </div>
                    </div>

                    <div class="action-buttons">
                        <button type="submit" class="btn-primary">
                            <i class="fas fa-key"></i> Ubah Password
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
    <script>
        // Preview foto profil
        document.getElementById('fotoProfilInput').addEventListener('change', function(e) {
            if (e.target.files && e.target.files[0]) {
                const reader = new FileReader();
                reader.onload = function(e) {
                    document.getElementById('profilePhotoPreview').src = e.target.result;
                }
                reader.readAsDataURL(e.target.files[0]);

                // Auto submit form
                document.getElementById('photoForm').submit();
            }
        });

        // Toggle password visibility
        function togglePassword(inputId) {
            const input = document.getElementById(inputId);
            const icon = event.target.closest('button').querySelector('i');

            if (input.type === 'password') {
                input.type = 'text';
                icon.classList.remove('fa-eye');
                icon.classList.add('fa-eye-slash');
            } else {
                input.type = 'password';
                icon.classList.remove('fa-eye-slash');
                icon.classList.add('fa-eye');
            }
        }

        // Check password strength
        function checkPasswordStrength(password) {
            const strengthBar = document.getElementById('passwordStrengthBar');
            const strengthText = document.getElementById('passwordStrengthText');

            let strength = 0;

            if (password.length >= 8) strength++;
            if (password.match(/[a-z]+/)) strength++;
            if (password.match(/[A-Z]+/)) strength++;
            if (password.match(/[0-9]+/)) strength++;
            if (password.match(/[$@#&!]+/)) strength++;

            strengthBar.className = 'password-strength-bar';

            if (strength < 3) {
                strengthBar.classList.add('password-strength-weak');
                strengthText.textContent = '❌ Password lemah';
                strengthText.style.color = '#dc3545';
            } else if (strength < 4) {
                strengthBar.classList.add('password-strength-medium');
                strengthText.textContent = '⚠️ Password sedang';
                strengthText.style.color = '#ffc107';
            } else {
                strengthBar.classList.add('password-strength-strong');
                strengthText.textContent = '✅ Password kuat';
                strengthText.style.color = '#28a745';
            }
        }

        // Touch feedback for mobile
        document.addEventListener('DOMContentLoaded', function() {
            const buttons = document.querySelectorAll('.btn-primary, .btn-change-photo, .btn-verify-face');
            buttons.forEach(button => {
                button.addEventListener('touchstart', () => {
                    button.style.transform = 'scale(0.98)';
                });
                button.addEventListener('touchend', () => {
                    button.style.transform = '';
                });
            });
        });
    </script>
@endpush
